//Source file: F:\jschwartz\src\Alkindi\BusinessDataTypes\ProductList.java

/* Copyright (C) 2000 Alikindi, LLC */

package Alkindi.Data;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Iterator;

/* 
$Header: ProductList.java, 10, 1/26/01 5:48:51 PM, Schwartz, Joe$
$Log: 
 10   Alkindi Development1.9         1/26/01 5:48:51 PM   Schwartz, Joe  
      Working on speed.
 9    Alkindi Development1.8         12/28/00 1:06:53 PM  Schwartz, Joe   Added
      version control header info.
 8    Alkindi Development1.7         12/26/00 7:21:16 PM  Schwartz, Joe   
 7    Alkindi Development1.6         12/26/00 6:57:25 PM  Schwartz, Joe   
 6    Alkindi Development1.5         12/18/00 6:08:37 PM  Schwartz, Joe   
 5    Alkindi Development1.4         12/18/00 12:05:38 PM Schwartz, Joe   Moved
      internal data classes to Utils package & regenerated classes from Rose.
 4    Alkindi Development1.3         10/23/00 5:35:38 PM  Schwartz, Joe   
 3    Alkindi Development1.2         10/19/00 1:12:16 PM  Schwartz, Joe   After
      10.19 Appian Delivery
 2    Alkindi Development1.1         10/6/00 4:13:41 PM   Schwartz, Joe   
 1    Alkindi Development1.0         9/21/00 4:11:13 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * A list of products.
 */
public class ProductList implements Serializable 
{
	private LinkedList internalList;
	
	public ProductList() 
	{
		internalList = new LinkedList();
	}
	
	/**
	 * @roseuid 39D369460119
	 */
	public boolean add(Product itemToAdd) 
	{
//		System.out.println("ProductList::add() called with product id=" + itemToAdd.productID + " and type=" + itemToAdd.productType);
		return internalList.add(itemToAdd);
	}
	
	/**
	 * @roseuid 39D3694802EE
	 */
	public Product get(int idx) 
	{
		return (Product)internalList.get(idx);
	}
	
	/**
	 * @roseuid 39D3694A001F
	 */
	public Iterator iterator() 
	{
		return internalList.iterator();
	}
	
	/**
	 * @roseuid 39D3694500CB
	 */
	public ProductList(int numInit) 
	{
		internalList = new LinkedList();//(numInit);
	}
	
	/**
	 * @roseuid 39D3694B01E4
	 */
	public int size() 
	{
		return internalList.size();
	}
	
	/**
	 * @roseuid 39F33B020157
	 */
	public Object remove(int idx) 
	{
		return internalList.remove(idx);
	}
	
	/**
	 * @roseuid 39F33B0700DA
	 */
	public boolean contains(Product product) 
	{
		return internalList.contains(product);
	}
	
	/**
	 * @return Object[]
	 * @roseuid 3A6C790700AB
	 */
	public Object[] toArray() 
	{
		return internalList.toArray();
	}
}
